
//Light//
////////

//Sources

struct lightSource
{
	vec3 position;
	vec3 diffuse;
	vec3 ambient;
	vec3 specular;
};


lightSource lightMorning = lightSource(
	LIGHTPOS,
	vec3(0.86, 	0.80, 	0.78),
	vec3(0.75, 	0.70, 	0.50),
	vec3(1.0, 	0.9, 	0.8)
);

lightSource lightNoon = lightSource(
	LIGHTPOS,
	vec3(0.87, 	0.86, 	0.82),
	vec3(0.73, 	0.70, 	0.40),
	vec3(1.0, 	1.0, 	0.8)
);

lightSource lightNoonMuggy = lightSource(
	LIGHTPOS,
	vec3(0.85, 	0.80, 	0.65),
	vec3(0.70, 	0.67, 	0.40),
	vec3(1.0, 	1.0, 	0.8)
);

lightSource lightAfternoon = lightSource(
	LIGHTPOS,
	vec3(0.88, 	0.87, 	0.80),
	vec3(0.72, 	0.69, 	0.40),
	vec3(1.0, 	1.0, 	0.8)
);

lightSource lightAfternoonLater = lightSource(
	LIGHTPOS,
	vec3(0.90, 	0.80, 	0.60),
	vec3(0.71, 	0.68, 	0.38),
	vec3(1.0, 	1.0, 	0.8)
);

lightSource lightCloudy = lightSource(
	LIGHTPOS,
	vec3(0.50, 	0.50, 	0.80),
	vec3(0.65, 	0.55, 	0.75),
	vec3(0.4, 	0.4, 	0.4)
);

lightSource lightEvening = lightSource(
	LIGHTPOS,
	vec3(0.85, 	0.70, 	0.60),
	vec3(0.75, 	0.70, 	0.40),
	vec3(1.0, 	1.0, 	0.6)
);

lightSource lightNight = lightSource(
	LIGHTPOS,
	vec3(0.20, 	0.25, 	0.40),
	vec3(0.45, 	0.40, 	0.65),
	vec3(0.2, 	0.2, 	0.2)
);

lightSource lightPsychedelic = lightSource(
	LIGHTPOS,
	vec3(0.90, 	0.89, 	0.85),
	vec3(0.90, 	0.40, 	0.50),
	vec3(1.0, 	1.0, 	0.8)
);



//Select Source

#if defined(DAYTIME_MORNING)
	lightSource currentLight = lightMorning;
#elif defined(DAYTIME_NOON)
	lightSource currentLight = lightNoon;
#elif defined(DAYTIME_NOON_MUGGY)
	lightSource currentLight = lightNoonMuggy;
#elif defined(DAYTIME_AFTERNOON)
	lightSource currentLight = lightAfternoon;
#elif defined(DAYTIME_AFTERNOON_LATER)
	lightSource currentLight = lightAfternoonLater;
#elif defined(DAYTIME_CLOUDY)
	lightSource currentLight = lightCloudy;
#elif defined(DAYTIME_EVENING)
	lightSource currentLight = lightEvening;
#elif defined(DAYTIME_NIGHT)
	lightSource currentLight = lightNight;
#elif defined(DAYTIME_PSYCHEDELIC)
	lightSource currentLight = lightPsychedelic;
#endif


//Functions

vec3 getNormalDirection(in mat3 m_3x3_inv_transp, in vec3 normal)
{
	return normalize(m_3x3_inv_transp * normal);
}

vec3 getLightDirection(in vec3 lightPos)
{
	return normalize(lightPos);
}

vec3 getViewDirection(in mat4 v_inv, in vec4 positionWorld)
{
	return normalize(vec3(v_inv * vec4(0.0, 0.0, 0.0, 1.0) - positionWorld));
}

vec3 getDiffuseReflection(in vec3 light, in vec3 material, in vec3 normalDirection, in vec3 lightDirection)
{
	const float minDiffuse = 0.1;
	return light * material * max(minDiffuse, dot(normalDirection, lightDirection));
}

vec3 getAmbientLighting(in vec3 light, in vec3 material)
{
	return light * material;
}

vec3 getSpecularReflection(in vec3 light, in vec3 material, in float shininess, in vec3 normalDirection, in vec3 lightDirection, in vec3 viewDirection)
{
	if(dot(normalDirection, lightDirection) < 0.0)
	{
		return vec3(0.0, 0.0, 0.0);
	}
	else
	{
		return light * material * pow(max(0.0, dot(reflect(-lightDirection, normalDirection), viewDirection)), shininess);
	}
}


